/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.engine.service;

import com.quantumdata.sct.dao.vo.AbstractCommandVO;
import com.quantumdata.sct.dao.vo.CommandInvocationVO;
import com.quantumdata.sct.dao.vo.ParameterVO;
import com.quantumdata.sct.dao.vo.ServiceVO;
import com.quantumdata.sct.engine.EngineException;
import com.quantumdata.sct.engine.IEngine;
import com.quantumdata.sct.engine.IEngineContext;
import com.quantumdata.sct.engine.service.CommandInvocationContext;
import com.quantumdata.sct.engine.service.ServiceEngineContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class ServiceEngine
implements IEngine {
    private ServiceVO serviceVO;

    public ServiceEngine(ServiceVO serviceVO) {
        this.serviceVO = serviceVO;
    }

    public Collection getParameters() throws EngineException {
        ArrayList<ParameterVO> arrayList = new ArrayList<ParameterVO>();
        for (CommandInvocationVO commandInvocationVO : this.serviceVO.getCommandInvocations()) {
            for (CommandInvocationVO.ParameterMappingVO parameterMappingVO : commandInvocationVO.getParmMaps()) {
                ParameterVO parameterVO = new ParameterVO();
                parameterVO.setName(parameterMappingVO.getServiceParameterName());
                parameterVO.setValue(parameterMappingVO.getCommandParameterValue());
                arrayList.add(parameterVO);
            }
        }
        return arrayList;
    }

    public IEngineContext prepareContext(IEngineContext iEngineContext) throws EngineException {
        return new ServiceEngineContext(iEngineContext, this.getParameters());
    }

    public int execute(IEngineContext iEngineContext) throws EngineException {
        int n = 0;
        Iterator iterator = this.serviceVO.getCommandInvocations().iterator();
        while (iterator.hasNext()) {
            try {
                CommandInvocationVO commandInvocationVO = (CommandInvocationVO)iterator.next();
                AbstractCommandVO abstractCommandVO = commandInvocationVO.getCommand();
                IEngine iEngine = abstractCommandVO.createEngine();
                CommandInvocationContext commandInvocationContext = new CommandInvocationContext(iEngineContext, commandInvocationVO);
                int n2 = iEngine.execute(commandInvocationContext);
                if (n2 > n) {
                    n = n2;
                }
                if (abstractCommandVO.getType() != 2 && abstractCommandVO.getType() != 3) continue;
                commandInvocationContext.copyOutputToParent();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return n;
    }
}

